/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator.actions;

import com.aptana.ide.ui.io.navigator.actions.EditorUtils;
import com.aptana.ide.ui.io.navigator.actions.Messages;
import com.aptana.ide.ui.io.navigator.actions.OpenFileAction;
import com.aptana.ui.io.epl.OpenWithMenu;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class OpenActionProvider
extends CommonActionProvider {
    private OpenFileAction fOpenFileAction;
    private ICommonViewerWorkbenchSite fSite;
    private boolean fContribute;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        if (aSite.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            this.fSite = (ICommonViewerWorkbenchSite)aSite.getViewSite();
            this.fOpenFileAction = new OpenFileAction();
            this.fContribute = true;
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.fContribute) {
            this.fOpenFileAction.selectionChanged(this.getSelection());
            menu.insertAfter("group.open", (IAction)this.fOpenFileAction);
            this.addOpenWithMenu(menu);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.fContribute) {
            this.fOpenFileAction.selectionChanged(this.getSelection());
            actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.fOpenFileAction);
        }
    }

    private void addOpenWithMenu(IMenuManager menu) {
        IStructuredSelection selection = this.getSelection();
        if (selection == null || selection.size() != 1) {
            return;
        }
        Object element = selection.getFirstElement();
        if (!(element instanceof IAdaptable)) {
            return;
        }
        MenuManager submenu = new MenuManager(Messages.OpenActionProvider_LBL_OpenWith, "group.openWith");
        submenu.add((IContributionItem)new GroupMarker("group.top"));
        submenu.add((IContributionItem)new OpenWithMenu(this.fSite.getPage(), (IAdaptable)element, new OpenWithMenu.Client(){

            public void openEditor(IFileStore file, IEditorDescriptor editorDescriptor) {
                EditorUtils.openFileInEditor(file, editorDescriptor);
            }
        }));
        submenu.add((IContributionItem)new GroupMarker("additions"));
        if (submenu.getItems().length > 2 && submenu.isEnabled()) {
            menu.appendToGroup("group.openWith", (IContributionItem)submenu);
        }
    }

    private IStructuredSelection getSelection() {
        return (IStructuredSelection)this.getContext().getSelection();
    }
}

